//
//  GSInfoValue.h
//  GlyphsCore
//
//  Created by Georg Seifert on 07.11.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSContainerProtocol.h>
#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
#import <GlyphsCore/GSIdentifiableParameter.h>
#endif

NS_ASSUME_NONNULL_BEGIN

@class GSMetric;

#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
@interface GSInfoValue : NSObject <NSCopying, GSIdentifiableParameter>
#else
@interface GSInfoValue : NSObject <NSCopying>
#endif
{
	CGFloat _value;
}

- (instancetype)initWithDict:(NSDictionary *)dict format:(GSFormatVersion)formatVersion;

- (instancetype)initWithValue:(CGFloat)value;

- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

- (BOOL)saveToFile:(FILE *)file format:(GSFormatVersion)formatVersion error:(NSError **)error;

@property (weak, nonatomic, nullable) GSContainer *parent;

@property (nonatomic, nullable, strong) NSString *parentKey;

@property (nonatomic, weak) GSMetric *metric;

/// The value.
@property (nonatomic) CGFloat value;

@property (readonly) NSString *name;

@end

NS_ASSUME_NONNULL_END
